###############################################################################
#	Filename:	blackelmtype2quantum.py
#	
#	Created:	20/05/02 -	Elminster
#	Modified:	02/2005 - Elminster
###############################################################################

import App

###############################################################################
#	Create(pTorp)
#	
#	Creates a Quantum Torpedo.
#	
#	Args:	pTorp - the torpedo, ready to be filled-in
#	
#	Return:	zero
###############################################################################
def Create(pTorp):
    kCoreColor = App.TGColorA()
    kCoreColor.SetRGBA((255.0 / 255.0), (255.0 / 255.0), (255.0 / 255.0), 1.0)
    kGlowColor = App.TGColorA()
    kGlowColor.SetRGBA((25.0 / 255.0), (25.0 / 255.0), (50.0 / 255.0), 1.0)
    kFlareColor = App.TGColorA()
    kFlareColor.SetRGBA((50.0 / 255.0), (50.0 / 255.0), (100.0 / 255.0), 1.0)
    pTorp.CreateTorpedoModel(
                                "data/Textures/Tactical/BlackelmquantumCore.tga",
                                kCoreColor,
                                0.2,
                                1.2,
                                "data/Textures/Tactical/BlackelmTorpedoGlow.tga",
                                kGlowColor,
                                3.0,
                                0.2,
                                0.4,
                                "data/Textures/Tactical/BlackelmTorpedoFlares.tga",
                                kFlareColor,
                                3,
                                0.15,
                                0.3)
    pTorp.SetDamage(GetDamage())
    pTorp.SetDamageRadiusFactor(0.14)
    pTorp.SetGuidanceLifetime(GetGuidanceLifetime())
    pTorp.SetMaxAngularAccel(GetMaxAngularAccel())

    # Multiplayer specific stuff.  Please, if you create a new torp
    # type. modify the SpeciesToTorp.py file to add the new type.
    import Multiplayer.SpeciesToTorp
    pTorp.SetNetType(Multiplayer.SpeciesToTorp.QUANTUM)
    
    return (0)


def GetLaunchSpeed():
    return (44.0)


def GetLaunchSound():
    return ("blackelmtype2quantum")


def GetPowerCost():
    return (10.0)


def GetName():
    return ("2 : Quantum")


def GetDamage():
    return 900.0


def GetGuidanceLifetime():
    return 6.0


def GetMaxAngularAccel():
    return 0.15

