###############################################################################
#	Filename:	blackelmtype6.py
#	
#	Confidential and Proprietary, Copyright 2000 by Totally Games
#	
#	Script for filling in the attributes of photon torpedoes.
#	
#	Created:	C2Xtreme
#	Modified:	02/2005 - Elminster
###############################################################################

import App

###############################################################################
#	Create(pTorp)
#	
#	Creates a photon torpedo.
#	
#	Args:	pTorp - the torpedo, ready to be filled-in
#	
#	Return:	zero
###############################################################################
def Create(pTorp):

	kGlowColor = App.TGColorA()
	kGlowColor.SetRGBA(255.0 / 255.0, 65.0 / 255.0, 0.0, 1.000000)	
	kCoreColor = App.TGColorA()
	kCoreColor.SetRGBA(255.0 / 255.0, 252.0 / 255.0, 100.0 / 255.0, 1.000000)
        kFlareColor = App.TGColorA()
	kFlareColor.SetRGBA(225.0/ 191.0, 255.0 / 49.0, 17.0 / 255.0, 1.000000)
	# Params are:



	pTorp.CreateTorpedoModel(
					"data/Textures/Tactical/blackelmTorpedoCore.tga",
					kCoreColor, 
					0.3,
					1.2,	 
					"data/Textures/Tactical/blackelmTorpedoGlow.tga", 
					kGlowColor,
					4.0,	
					0.3,	 
					0.2,	
					"data/Textures/Tactical/blackelmTorpedoFlares.tga",
					kGlowColor,						
					20,		
					0.3,		
					0.5)

	pTorp.SetDamage( GetDamage() )
	pTorp.SetDamageRadiusFactor(0.13)
	pTorp.SetGuidanceLifetime( GetGuidanceLifetime() )
	pTorp.SetMaxAngularAccel( GetMaxAngularAccel() )

	# Multiplayer specific stuff.  Please, if you create a new torp
	# type. modify the SpeciesToTorp.py file to add the new type.
	import Multiplayer.SpeciesToTorp
	pTorp.SetNetType (Multiplayer.SpeciesToTorp.PHOTON)

	return(0)

def GetLaunchSpeed():
	return(30.0)

def GetLaunchSound():
	return("blackelmtype6photon")

def GetPowerCost():
	return(20.0)

def GetName():
	return("6 : Photon")

def GetDamage():
	return 1000.0

def GetGuidanceLifetime():
	return 8.0

def GetMaxAngularAccel():
	return 0.15
